\name{createChrMatrix}
\alias{createChrMatrix}

\title{Generate chromosome-based subset matrices from the mapped data
  structures generated by makeChrStrandData}

\description{

  Given a data object from makeChrStrandData, generate a matrix
  containing a subset of the data from a given region of a given
  chromosome strand, with data binned at appropriate intervals along the
  chromosome. The minimum width of the binning interval is controlled
  using the "interval" argument, which can therefore be used to control
  the output resolution of the data.

}
\usage{
createChrMatrix(data, chr, strand = c('forward','reverse','both'), subset = NULL,
                start=1, end, interval=ceiling((end - start)/500))
}
\arguments{

  \item{data}{A ChrStrandData object (e.g. generated by \code{makeChrStrandData}).}

  \item{chr}{The name of the chromosome to plot.}

  \item{strand}{The chromosome strand to plot (`both' indicates that both
    strands should be overlaid in a single heatmap).}

  \item{subset}{An optional numeric vector indicating which samples should be
    plotted.}

  \item{start}{The starting chromosome coordinate from which to plot.}

  \item{end}{The ending chromosome coordinate.}

  \item{interval}{The (optional) size of the data bins to use along the chromosome,
    in bases.}
}
\details{

  Typically this function will not be called directly, but rather via
  the wrapper \code{plotChrMap} function.

  Note that this function may combine data from multiple probes or genes (taking
  the mean) into a single chromosomal locus based on the size of the
  specified interval. If this happens the combined probe/gene identifiers are
  concatenated in the output object, separated by a semicolon.
  
}
\value{
  A ChrStrandMatrix object suitable for use with \code{chrHeatMap} and
  \code{drawMapDendro}.
}
\author{ Tim F Rayner }
\seealso{
  \code{\link{plotChrMap}}, \code{\link{chrHeatMap}},
  \code{\link{drawMapDendro}}, \code{\link{ChrStrandMatrix-class}}, \code{\link{ChrStrandData-class}}
}
\examples{
data('demo')
stranddata <- createChrMatrix( chrdata, chr=22, strand='forward', start=21925000, end=24300000 )
}
\keyword{array}
