% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy_number.R
\name{calculate_cyto_mat}
\alias{calculate_cyto_mat}
\title{Calculate Fraction of reads in each cytobands}
\usage{
calculate_cyto_mat(scExp, ref_genome = c("hg38", "mm10", "ce11")[1])
}
\arguments{
\item{scExp}{A SingleCellExperiment with genomic coordinate as features
(peaks or bins)}

\item{ref_genome}{Reference genome ('hg38' or 'mm10')}
}
\value{
The SCE with the fraction of reads in each cytobands in each cells
(of dimension cell x cytoband ) in the  reducedDim slot "cytoBand".
}
\description{
Re-Count binned reads onto cytobands and calculate the fraction of reads in
each of the cytoband in each cell. For each cell, the fraction of reads in
any given cytoband is calculated.
Cytobands are considered large enough in order that a variation at the
cytoband level is not considered as an epigenetic event but as a genetic
event, e.g. Copy Number Alterations.
}
\examples{

data("scExp")
scExp = calculate_cyto_mat(scExp, ref_genome="hg38")
SingleCellExperiment::reducedDim(scExp, "cytoBand") 

}
