% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing_filtering_reduction.R
\name{create_scDataset_raw}
\alias{create_scDataset_raw}
\title{Create a simulated single cell datamatrix & cell annotation}
\usage{
create_scDataset_raw(
  cells = 300,
  features = 600,
  featureType = c("window", "peak", "gene"),
  sparse = TRUE,
  nsamp = 4,
  ref = "hg38",
  batch_id = factor(rep(1, nsamp))
)
}
\arguments{
\item{cells}{Number of cells (300)}

\item{features}{Number of features (600)}

\item{featureType}{Type of feature (window)}

\item{sparse}{Is matrix sparse ? (TRUE)}

\item{nsamp}{Number of samples (4)}

\item{ref}{Reference genome ('hg38')}

\item{batch_id}{Batch origin (factor((1,1,1,1))}
}
\value{
A list composed of * mat : a sparse matrix following an approximation
of the negative binomial law (adapted to scChIPseq) * annot : a data.frame
of cell annotation * batches : an integer vector with the batch number for
each cell
}
\description{
Create a simulated single cell datamatrix & cell annotation
}
\examples{
# Creating a basic sparse 600 genomic bins x 300 cells matrix and annotation
l = create_scDataset_raw()
head(l$mat)
head(l$annot)
head(l$batches)

# Specifying number of cells, features and samples
l2 = create_scDataset_raw(cells = 500, features = 500, nsamp=2)

# Specifying species
mouse_l = create_scDataset_raw(ref="mm10")

# Specifying batches
batch_l = create_scDataset_raw(nsamp=4, batch_id = factor(c(1,1,2,2)))

# Peaks of different size as features
peak_l = create_scDataset_raw(featureType="peak")
head(peak_l$mat)

# Genes as features
gene_l = create_scDataset_raw(featureType="gene")
head(gene_l$mat)
}
