% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing_filtering_reduction.R
\name{define_feature}
\alias{define_feature}
\title{Define the features on which reads will be counted}
\usage{
define_feature(ref = c("hg38","mm10", "ce11")[1],
 peak_file = NULL,
 bin_width  = NULL,
 genebody = FALSE,
 extendPromoter = 2500)
}
\arguments{
\item{ref}{Reference genome}

\item{peak_file}{A bed file if counting on peaks}

\item{bin_width}{A number of bins if divinding genome into fixed width bins}

\item{genebody}{A logical indicating if feature should be counted in
genebodies and promoter.}

\item{extendPromoter}{Extension length before TSS (2500).}
}
\value{
A GRanges object
}
\description{
Define the features on which reads will be counted
}
\examples{
gr_bins = define_feature("hg38", bin_width = 50000)
gr_genes = define_feature("hg38", genebody = TRUE, extendPromoter = 5000)

}
