% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_analysis.R
\name{generate_report}
\alias{generate_report}
\title{From a ChromSCape analysis directory, generate an HTML report.}
\usage{
generate_report(
  ChromSCape_directory,
  prefix = NULL,
  run = c("filter", "CNA", "cluster", "consensus", "peak_call", "coverage", "DA", "GSA",
    "report")[c(1, 3, 6, 7, 8, 9)],
  genes_to_plot = c("Krt8", "Krt5", "Tgfb1", "Foxq1", "Cdkn2b", "Cdkn2a",
    "chr7:15000000-20000000"),
  control_samples_CNA = NULL
)
}
\arguments{
\item{ChromSCape_directory}{Path towards the ChromSCape directory of which
you want to create the report. The report will be created at the root of this
directory.}

\item{prefix}{Name of the analysis with the filtering parameters
(e.g. Analysis_3000_100000_99_uncorrected). You will find the prefix in the
Filtering_Normalize_Reduce subfolder.}

\item{run}{Which steps to report ("filter", "CNA","cluster", "consensus", "peak_call",
"coverage", "DA", "GSA", "report"). Only indicate steps that were done in the
analysis. By default do not report CNA, consensus and peak calling.}

\item{genes_to_plot}{For the UMAP, which genes do you want to see in the
report.}

\item{control_samples_CNA}{If running the Copy Number Alteration (CNA) part,
which samples are the controls}
}
\value{
Generate an HTML report at the root of the analysis directory.
}
\description{
From a ChromSCape analysis directory, generate an HTML report.
}
\examples{

\dontrun{
generate_analysis("/path/to/data/", "Analysis_1")
}
}
