% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff_analysis_gene_set_enrichment.R
\name{get_pathway_mat_scExp}
\alias{get_pathway_mat_scExp}
\title{Get pathway matrix}
\usage{
get_pathway_mat_scExp(
  scExp,
  pathways,
  max_distanceToTSS = 1000,
  ref = "hg38",
  GeneSetClasses = c("c1_positional", "c2_curated", "c3_motif", "c4_computational",
    "c5_GO", "c6_oncogenic", "c7_immunologic", "hallmark"),
  progress = NULL
)
}
\arguments{
\item{scExp}{A SingleCellExperiment}

\item{pathways}{A character vector specifying the pathways to retrieve the
cell count for.}

\item{max_distanceToTSS}{Numeric. Maximum distance to a gene's TSS to consider
a region linked to a gene. (1000)#' @param ref}

\item{ref}{Reference genome, either mm10 or hg38}

\item{GeneSetClasses}{Which classes of MSIGdb to load}

\item{progress}{A shiny Progress instance to display progress bar.}
}
\value{
A matrix of cell to pathway
}
\description{
Get pathway matrix
}
\examples{
data(scExp)
mat = get_pathway_mat_scExp(scExp, pathways = "KEGG_T_CELL_RECEPTOR_SIGNALING_PATHWAY")

}
