% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing_filtering_reduction.R
\name{num_cell_after_QC_filt_scExp}
\alias{num_cell_after_QC_filt_scExp}
\title{Table of cells before / after QC}
\usage{
num_cell_after_QC_filt_scExp(scExp, annot, datamatrix)
}
\arguments{
\item{scExp}{A SingleCellExperiment object.}

\item{annot}{A raw annotation data.frame of cells before filtering.}

\item{datamatrix}{A matrix of cells per regions  before filtering.}
}
\value{
A formatted kable in HTML.
}
\description{
Table of cells before / after QC
}
\examples{
raw <- create_scDataset_raw()
scExp = create_scExp(raw$mat, raw$annot)
scExp_filtered = filter_scExp(scExp)
\dontrun{ num_cell_after_QC_filt_scExp(
scExp_filtered,as.data.frame(SingleCellExperiment::colData(scExp)), counts(scExp))}

}
