% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_violin_feature_scExp}
\alias{plot_violin_feature_scExp}
\title{Violin plot of features}
\usage{
plot_violin_feature_scExp(
  scExp,
  gene,
  by = c("cell_cluster", "sample_id")[1],
  downsample = 5000,
  max_distanceToTSS = 1000
)
}
\arguments{
\item{scExp}{A SingleCellExperiment}

\item{gene}{A character specifying the gene to plot}

\item{by}{Color violin by cell_cluster or sample_id  ("cell_cluster")}

\item{downsample}{Downsample for plotting (5000)}

\item{max_distanceToTSS}{Numeric. Maximum distance to a gene's TSS to consider
a region linked to a gene. (1000)}
}
\value{
A violin plot of intra-correlation
}
\description{
Violin plot of features
}
\examples{
data(scExp)
plot_violin_feature_scExp(scExp, "UBXN10")

}
