% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{warning_plot_reduced_dim_scExp}
\alias{warning_plot_reduced_dim_scExp}
\title{A warning helper for plot_reduced_dim_scExp}
\usage{
warning_plot_reduced_dim_scExp(
  scExp,
  color_by,
  reduced_dim,
  downsample,
  transparency,
  size,
  max_distanceToTSS,
  annotate_clusters,
  min_quantile,
  max_quantile
)
}
\arguments{
\item{scExp}{A SingleCellExperiment Object}

\item{color_by}{Feature used for coloration}

\item{reduced_dim}{Reduced Dimension used for plotting}

\item{downsample}{Number of cells to downsample}

\item{transparency}{Alpha parameter, between 0 and 1}

\item{size}{Size of the points.}

\item{max_distanceToTSS}{Numeric. Maximum distance to a gene's TSS to consider
a region linked to a gene.}

\item{annotate_clusters}{A logical indicating if clusters should be labelled.
The 'cell_cluster' column should be present in metadata.}

\item{min_quantile}{The lower threshold to remove outlier cells,
as quantile of cell embeddings (between 0 and 0.5).}

\item{max_quantile}{The upper threshold to remove outlier cells,
as quantile of cell embeddings (between 0.5 and 1).}
}
\value{
Warning or errors if the inputs are not correct
}
\description{
A warning helper for plot_reduced_dim_scExp
}
