% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClustAll_ClustAllObject_Class.R
\docType{data}
\name{heart_data}
\alias{heart_data}
\title{Heart Disease Dataset}
\format{
A data frame with 918 rows and 12 variables:
\describe{
  \item{Age}{Numeric. Age of the patient in years.}
  \item{Sex}{Categorical. Patient's gender (M = Male, F = Female).}
  \item{ChestPainType}{Categorical. Type of chest pain experienced (TA = Typical Angina, ATA = Atypical Angina, NAP = Non-Anginal Pain, ASY = Asymptomatic).}
  \item{RestingBP}{Numeric. Resting blood pressure in mm Hg.}
  \item{Cholesterol}{Numeric. Serum cholesterol in mg/dl.}
  \item{FastingBS}{Binary. Fasting blood sugar > 120 mg/dl (1 = true; 0 = false).}
  \item{RestingECG}{Categorical. Resting electrocardiogram results (Normal, ST = having ST-T wave abnormality, LVH = showing probable or definite left ventricular hypertrophy by Estes' criteria).}
  \item{MaxHR}{Numeric. Maximum heart rate achieved.}
  \item{ExerciseAngina}{Categorical. Exercise-induced angina (Y = Yes, N = No).}
  \item{Oldpeak}{Numeric. ST depression induced by exercise relative to rest.}
  \item{ST_Slope}{Categorical. The slope of the peak exercise ST segment (Up, Flat, Down).}
  \item{HeartDisease}{Binary. Output class (1 = heart disease, 0 = normal).}
}
}
\source{
Kaggle: https://www.kaggle.com/datasets/johnsmith88/heart-disease-dataset
}
\usage{
data("heart_data", package = "ClustAll")
}
\value{
heart dataset
}
\description{
The dataset comprises both categorical and numerical features derived from
medical examinations and patient history. Each row represents a patient,
characterized by 13 attributes, with the target variable indicating the
presence or absence of heart disease.
}
\details{
This dataset contains various medical and lifestyle attributes of patients,
along with their heart disease diagnosis status. It is commonly used for
predicting the presence of heart disease in patients.


This dataset is valuable for developing and testing machine learning models
for heart disease prediction. It includes a mix of demographic information,
vital signs, and results from various medical tests, making it a comprehensive
resource for studying factors associated with heart disease.
}
\keyword{datasets}
