% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClustAll_ClustAllObject_Class.R
\docType{data}
\name{wdbc}
\alias{wdbc}
\title{wdbc: Diagnostic Wisconsin Breast Cancer Database.}
\format{
A data frame with 660 rows and 31 variables
}
\source{
<https://archive.ics.uci.edu/dataset/17/breast+cancer+wisconsin+diagnostic>

\itemize{
  \item Diagnosis Label says tumor is malingnant or benignant
  \item radius. Mean of distances from the center to points on the perimeter
  \item perimeter
  \item area
  \item smoothness. Local variation in radius lengths
  \item compactness. (Perimeter^2 / Area) - 1.0
  \item concavity. Severity of concave portions of the contour
  \item concave points. Number of concave portions of the contour
  \item symmetry.
  \item fractal dimension. “Coastline approximation” - 1.
}
}
\usage{
data("BreastCancerWisconsin", package = "ClustAll")
}
\value{
wdbc dataset
}
\description{
The Breast Cancer Wisconsin (Diagnostic) dataset, also known as "wdbc", contains
features computed from digitized images of fine needle aspirates (FNA) of breast
masses. The features describe characteristics of the cell nuclei present in each image.
}
\details{
The dataset includes 569 patients, each characterized by 30 numerical features and one
categorical feature. The numerical features are computed from ten different measurements
of the cell nuclei, and each measurement is repeated three times, resulting in a total
of 30 features per patient (10 features x 3 measurements).

The categorical feature is the diagnosis, which indicates whether the tumor is
malignant (M) or benign (B). This feature serves as the target class for
classification tasks.
}
\keyword{datasets}
