% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoGAPS.R
\name{CoGAPS}
\alias{CoGAPS}
\title{CoGAPS Matrix Factorization Algorithm}
\usage{
CoGAPS(
  data,
  params = new("CogapsParams", nPatterns = nPatterns),
  nPatterns,
  nThreads = 1,
  messages = TRUE,
  outputFrequency = 1000,
  uncertainty = NULL,
  checkpointOutFile = "gaps_checkpoint.out",
  checkpointInterval = 0,
  checkpointInFile = NULL,
  transposeData = FALSE,
  BPPARAM = NULL,
  workerID = 1,
  asynchronousUpdates = TRUE,
  nSnapshots = 0,
  snapshotPhase = "sampling",
  ...
)
}
\arguments{
\item{data}{File name or R object (see details for supported types)}

\item{params}{CogapsParams object}

\item{nPatterns}{rank of the nmf decomposition}

\item{nThreads}{maximum number of threads to run on}

\item{messages}{T/F for displaying output}

\item{outputFrequency}{number of iterations between each output (set to 0 to
disable status updates, other output is controlled by @code messages)}

\item{uncertainty}{uncertainty matrix - either a matrix or a supported
file type}

\item{checkpointOutFile}{name of the checkpoint file to create}

\item{checkpointInterval}{number of iterations between each checkpoint (set
to 0 to disable checkpoints)}

\item{checkpointInFile}{if this is provided, CoGAPS runs from the checkpoint
contained in this file}

\item{transposeData}{T/F for transposing data while reading it in - useful
for data that is stored as samples x genes since CoGAPS requires data to be
genes x samples}

\item{BPPARAM}{BiocParallel backend}

\item{workerID}{if calling CoGAPS in parallel the worker ID can be specified,
only worker 1 prints output and each worker outputs when it finishes, this
is not neccesary when using the default parallel methods (i.e. distributed
CoGAPS) but only when the user is manually calling CoGAPS in parallel}

\item{asynchronousUpdates}{enable asynchronous updating which allows for multi-threaded runs}

\item{nSnapshots}{how many snapshots to take in each phase, setting this to 0 disables
snapshots}

\item{snapshotPhase}{which phase to take snapsjots in e.g. "equilibration", "sampling",
"all"}

\item{...}{allows for overwriting parameters in params}
}
\value{
CogapsResult object
}
\description{
calls the C++ MCMC code and performs Bayesian
matrix factorization returning the two matrices that reconstruct
the data matrix
}
\details{
The supported R types are: matrix, data.frame, SummarizedExperiment,
SingleCellExperiment. The supported file types are csv, tsv, and mtx.
}
\examples{
# Running from R object
data(GIST)
resultA <- CoGAPS(GIST.data_frame, nPatterns=3, nIterations=25)

# Running from file name
gist_path <- system.file("extdata/GIST.mtx", package="CoGAPS")
resultB <- CoGAPS(gist_path, nPatterns=3, nIterations=25)

# Setting Parameters
params <- new("CogapsParams", nPatterns=3)
params <- setParam(params, "nIterations", 25)
resultC <- CoGAPS(GIST.data_frame, params)
}
