\name{export.wig}
\alias{export.wig}
\alias{export.wig,numeric-method}
\title{Generates a WIG file containing the coverage values for a certain genomic interval}
\description{Write the coverage values calculated using the \code{cov.interval} function into a WIG format file}
\usage{
\S4method{export.wig}{numeric}(cov,outfile=NULL)
}
\arguments{
  \item{cov}{Numeric vector containing the coverage values generated by the function \code{cov.interval}}
  \item{outfile}{Where to write the \code{.WIG} format file that will contain the coverages}
}
\details{
This method is used to write the coverage values calculated by the \code{cov.interval} function into a WIG format file. 
}
\references{
WIG format specification: https://genome.ucsc.edu/FAQ/FAQformat.html
}
\author{
Ernesto Lowy <ernestolowy@gmail.com>
}
\seealso{
\code{\link{cov.interval}}
}
\examples{
#get treatment and control test files
treat1file<-system.file("extdata","treat.bam",package="CoverageView")
control1file<-system.file("extdata","ctrl.bam",package="CoverageView")
  
#create two CoverageBamFile objects representing single-end alignments
trm1<-CoverageBamFile(treat1file,run_type="single")
ctl1<-CoverageBamFile(control1file,run_type="single")
  
#calculate the ratio of the coverages for the defined genomic interval using a bin_width equal to 10 nts
cov1=cov.interval(trm1,ctl1,chr="chrI",start=1,end=100,bin_width=10,do="ratio")
  
#create a WIG file with the obtained vector with the ratios
outfolder=system.file("extdata",package="CoverageView")
an_outfile1=paste(outfolder,"out.wig",sep="/")
export.wig(cov1,outfile=an_outfile1)
}
