% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialisers.R
\name{collapsePairs}
\alias{collapsePairs}
\title{Internal CrispRVariants function for collapsing pairs with concordant indels}
\usage{
collapsePairs(
  alns,
  use.consensus = TRUE,
  keep.unpaired = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{alns}{A GAlignments object.  We do not use GAlignmentPairs because amplicon-seq
can result in pairs in non-standard pairing orientation.
Must include BAM flag, must not include unmapped reads.}

\item{use.consensus}{Should the consensus sequence be used if pairs have a mismatch?
Setting this to be TRUE makes this function much slower (Default: TRUE)}

\item{keep.unpaired}{Should unpaired and chimeric reads be included?  (Default: TRUE)}

\item{verbose}{Report statistics on reads kept and excluded}

\item{...}{Additional items with the same length as alns,
that should be filtered to match alns.}
}
\value{
The alignments, with non-concordant pairs removed and concordant pairs
represented by a single read.
}
\description{
Given a set of alignments to a target region, finds read pairs.
Compares insertion/deletion locations within pairs using the cigar string.
Pairs with non-identical indels are excluded.  Pairs with identical indels are
collapsed to a single read, taking the consensus sequence of the pairs.
}
\author{
Helen Lindsay
}
