% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{.getAxisCoords}
\alias{.getAxisCoords}
\title{.getAxisCoords}
\usage{
.getAxisCoords(
  locations,
  labels = NULL,
  loc.boundaries = NULL,
  lab.boundaries = c(-1, 1),
  label.at = 5,
  min.tick.sep = 1
)
}
\arguments{
\item{locations}{character(n) Actual x coordinates, or the desired
range of the x coordinates.  If labels are provided, all tick locations
must be in locations and have a matching label.}

\item{labels}{character(n) labels for the x axis ticks.  Should be
the same length as locations if provided.  Note that if not all
tick locations are included in locations, it must be possible to
extrapolate labels from locations  (Default: NULL)}

\item{loc.boundaries}{numeric(i) Locations that must be included.
(Default: NULL)}

\item{lab.boundaries}{numeric(j) Labels that must be included.
(Default: c(-1,1), for showing the cut sites).  Boundaries must
be in labels and have a matching tick location.}

\item{label.at}{numeric(1) Add ticks when label modulo label.at
is zero (Default = 5)}

\item{min.tick.sep}{numeric(1) Minimum distance between ticks, excluding
boundary ticks.  (Default: 1)}
}
\value{
A list containing vectors named tick_locs and tick_labs
}
\description{
Manually specify x-tick locations and labels,
as sometimes ggplot defaults are too dense. Used internally
by CrispRVariants for creating alignment plot with plotAlignments.
}
\author{
Helen Lindsay
}
