% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{countDeletions}
\alias{countDeletions}
\alias{countDeletions,GAlignments-method}
\alias{countInsertions}
\alias{countInsertions,GAlignments-method}
\alias{countIndels}
\alias{countIndels,GAlignments-method}
\alias{indelPercent}
\alias{indelPercent,GAlignments-method}
\title{Count the number of reads containing an insertion or deletion}
\usage{
countDeletions(alns, ...)

\S4method{countDeletions}{GAlignments}(
  alns,
  ...,
  multi.del = FALSE,
  del.and.ins = FALSE,
  del.ops = c("D")
)

countInsertions(alns, ...)

\S4method{countInsertions}{GAlignments}(
  alns,
  ...,
  ins.and.del = FALSE,
  multi.ins = FALSE,
  del.ops = c("D")
)

countIndels(alns)

\S4method{countIndels}{GAlignments}(alns)

indelPercent(alns)

\S4method{indelPercent}{GAlignments}(alns)
}
\arguments{
\item{alns}{The aligned reads}

\item{...}{extra arguments}

\item{multi.del}{If TRUE, returns the exact number of deletions,
i.e., if one read contains 2 deletions, it contributes 2 to the
total count (default: FALSE)}

\item{del.and.ins}{If TRUE, counts deletions regardless of whether
reads also contain insertions.  If FALSE, counts reads that contain
deletions but not insertions (default: FALSE)}

\item{del.ops}{Cigar operations counted as deletions.  Default: c("D")}

\item{ins.and.del}{If TRUE, counts insertions regardless of whether
reads also contain deletions  If FALSE, counts reads that contain
insertions but not deletions (default: FALSE)}

\item{multi.ins}{If TRUE, returns the exact number of insertions,
i.e., if one read contains 2 insertions, it contributes 2 to the
total count (default: FALSE)}
}
\value{
countDeletions: The number of reads containing a deletion (integer)

countInsertions: The number of reads containing an insertion (integer)

countIndels: The number of reads containing at least one insertion

indelPercent: The percentage of reads containing an insertion or
deletion (numeric)
}
\description{
Counts the number of reads containing a deletion or insertion
(indel) of any size in a set of aligned reads.
For countDeletions and countInsertions Reads may be filtered according to
whether they contain more than one indel of the same or different types.
}
\examples{
bam_fname <- system.file("extdata", "gol_F1_clutch_2_embryo_4_s.bam",
                         package = "CrispRVariants")
bam <- GenomicAlignments::readGAlignments(bam_fname, use.names = TRUE)
countDeletions(bam)
countInsertions(bam)
countIndels(bam)
indelPercent(bam)
}
\author{
Helen Lindsay
}
