% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeChimeras.R
\name{mergeChimeras}
\alias{mergeChimeras}
\title{mergeChimeras}
\usage{
mergeChimeras(
  bam,
  chimera_idxs = NULL,
  verbose = TRUE,
  max_read_overlap = 10,
  max_unmapped = 4,
  name = NULL
)
}
\arguments{
\item{bam}{A GenomicAlignments::GAlignments object}

\item{chimera_idxs}{Indices of chimeric reads within bam}

\item{verbose}{Should information about the number of mergeable
alignments be printed?  (Default: TRUE)}

\item{max_read_overlap}{Maximum number of bases in a mergeable read
that are aligned to two genomic locations (Default: 10)}

\item{max_unmapped}{Maximum number of bases in a mergeable read
that are unmapped and located between two mapped segments (Default: 4)}

\item{name}{Name of the sample, used when reporting verbose output.}
}
\value{
A list of the merged and unmerged chimeric alignments
}
\description{
Merges chimeric alignments where the individual segments
border an unmapped region (a long deletion).  If bases of the read are
mapped to both ends of the gap, the multimapped reads are only included
in the leftmost genomic segment. If there are more than max_unmapped
unmapped bases between the mapped bases, the read is not considered
mergeable.  Currently experimental and only tested with reads mapped by
bwa mem.
}
\author{
Helen Lindsay
}
