% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readsByPCRPrimer.R
\name{readsByPCRPrimer}
\alias{readsByPCRPrimer}
\alias{readsByPCRPrimer,GAlignments,GRanges-method}
\alias{readsByPCRPrimer,GRanges,GRanges-method}
\title{Finds overlaps between aligned reads and PCR primers}
\usage{
readsByPCRPrimer(bam, primers, ...)

\S4method{readsByPCRPrimer}{GAlignments,GRanges}(
  bam,
  primers,
  ...,
  tolerance = 0,
  verbose = TRUE,
  ignore.strand = TRUE,
  allow.partial = TRUE,
  chimera.idxs = NULL
)

\S4method{readsByPCRPrimer}{GRanges,GRanges}(
  bam,
  primers,
  ...,
  tolerance = 0,
  verbose = TRUE,
  ignore.strand = TRUE,
  allow.partial = TRUE,
  chimera.idxs = NULL
)
}
\arguments{
\item{bam}{A set of aligned reads}

\item{primers}{A set of ranges that the unclipped reads may map to}

\item{...}{Additional arguments}

\item{tolerance}{Number of bases by which reads and primers may differ
at each end (Default: 0)}

\item{verbose}{Print number of full and partial matches (Default: TRUE)}

\item{ignore.strand}{Passed to \code{\link[GenomicAlignments]{findOverlaps}}
and \code{\link[GenomicRanges]{disjoin}}. Should strand be ignored when
finding overlaps.  (Default: TRUE)}

\item{allow.partial}{Should reads that do not match the PCR boundaries, but
map to a region covered by only one primer be considered matches?  (Default: TRUE)}

\item{chimera.idxs}{Indices of chimeric reads within the bam.  If specified,
chimeras overlapping multiple pcr primers will be removed.}
}
\value{
A \code{\link[S4Vectors]{Hits}} object where "query" is the index with
respect to bam and "subject" is the index with respect to the primers.
}
\description{
Short reads amplified with PCR primers should start and end
at defined positions.  However, the ends of an aligned read may be clipped
as sequencing technologies are prone to making errors at the start and end.
readsByPCRPrimer extrapolates the genomic location of entire reads
from their aligned sections by adding clipped sections, then finds near
exact matches to a set of PCR primers.  Note that this is not always a good
assumption, and is misleading in the case of chimeric reads where sections
clipped in one part of a chimera are aligned in another.
}
\seealso{
\code{\link[GenomicRanges]{GRanges}}, \code{\link[GenomicAlignments]{GAlignments}}
}
\author{
Helen Lindsay
}
