% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refFromAlns.R
\name{refFromAlns}
\alias{refFromAlns}
\alias{refFromAlns,GAlignments,ANY-method}
\alias{refFromAlns,GAlignments,GRanges-method}
\title{refFromAlns}
\usage{
refFromAlns(alns, location, ...)

\S4method{refFromAlns}{GAlignments,ANY}(alns, location, ..., keep.names = FALSE)

\S4method{refFromAlns}{GAlignments,GRanges}(alns, location, ...)
}
\arguments{
\item{alns}{Alignments to use for inferring the reference sequence}

\item{location}{The location to infer the reference for.}

\item{...}{additional arguments}

\item{keep.names}{Should read names be added to the result if present?
(Default: FALSE)}
}
\value{
The reference sequences corresponding to the provided alignments

A DNAStringSet (signature = c("GAlignments", "ANY"))

A DNAString (signature = c("GAlignments", "GRanges"))
}
\description{
Reconstruct the reference sequence from alignments reads using the CIGAR
}
\examples{
bam <- system.file("extdata", "bam/ab1_ptena_wildtype_looking_embryo_1_s.bam",
                  package = "CrispRVariants")
alns <- GenomicAlignments::readGAlignments(bam,
          param = Rsamtools::ScanBamParam(tag = "MD", what = "seq"))
# To get the reference sequence from the a given location:
location <- GenomicRanges::GRanges("chr17", IRanges::IRanges(23648420,23648430))
refFromAlns(alns, location = location)
}
\author{
Helen Lindsay
}
