% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unharmonised.R
\name{get_unharmonised_metadata}
\alias{get_unharmonised_metadata}
\title{Returns unharmonised metadata for a metadata query}
\usage{
get_unharmonised_metadata(metadata, ...)
}
\arguments{
\item{metadata}{A lazy data frame obtained from \code{\link[=get_metadata]{get_metadata()}}, filtered
down to some cells of interest}

\item{...}{
  Arguments passed on to \code{\link[=get_unharmonised_dataset]{get_unharmonised_dataset}}
  \describe{
    \item{\code{dataset_id}}{A character vector, where each entry is a dataset ID
obtained from the \verb{$file_id} column of the table returned from
\code{\link[=get_metadata]{get_metadata()}}}
    \item{\code{cells}}{An optional character vector of cell IDs. If provided, only
metadata for those cells will be returned.}
    \item{\code{conn}}{An optional DuckDB connection object. If provided, it will re-use
the existing connection instead of opening a new one.}
    \item{\code{remote_url}}{Optional character vector of length 1. An HTTP URL pointing
to the root URL under which all the unharmonised dataset files are located.}
    \item{\code{cache_directory}}{Optional character vector of length 1. A file path on
your local system to a directory (not a file) that will be used to store
the unharmonised metadata files.}
  }}
}
\value{
A tibble with two columns:
\itemize{
\item \code{file_id}: the same \code{file_id} as the main metadata table obtained from
\code{\link[=get_metadata]{get_metadata()}}
\item \code{unharmonised}: a nested tibble, with one row per cell in the input
\code{metadata}, containing unharmonised metadata
}
}
\description{
Various metadata fields are \emph{not} common between datasets, so it does not
make sense for these to live in the main metadata table. This function is a
utility that allows easy fetching of this data if necessary.
}
\examples{
harmonised <- dplyr::filter(get_metadata(), tissue == "kidney blood vessel")
unharmonised <- get_unharmonised_metadata(harmonised)
}
