% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_generation_nb_parameters_optimized.R
\name{function_value_onemarker}
\alias{function_value_onemarker}
\title{Compute simulated cell values for one marker with markers NB informations}
\usage{
function_value_onemarker(
  marker_name,
  mu0,
  dispersion,
  subject_effect,
  nb_donor,
  nb_cell_per_sample,
  rho = 1
)
}
\arguments{
\item{marker_name}{character, name of the marker.}

\item{mu0}{numeric, general donor mean from which the individual mu0i will
be drawn.}

\item{dispersion}{numeric, dispersion of the markers.}

\item{subject_effect}{numeric, standard deviation for the normal distribution
from which the donor's means will be drawn (by default subject_effect = 0.01).}

\item{nb_donor}{numeric, number of donors.}

\item{nb_cell_per_sample}{numeric, number of cells per sample (by default
nb_cell_per_sample = 500).}

\item{rho}{numeric, fold change.}
}
\value{
data.frame of cell values.
}
\description{
Compute simulated cell values for one marker with markers NB informations
}
\details{
Function to generate value for one marker with a mean and dispersion
specified for the negative binomiale.
}
\keyword{internal}
