% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treeGate.R
\name{treeGate}
\alias{treeGate}
\title{Use decision tree to find a group of cells that are associated with clinical
outcome.}
\usage{
treeGate(P, x, ...)
}
\arguments{
\item{P}{The predicted association of each cell with a clinical outcome.}

\item{x}{The marker profile of each cell. Each row is a cell, each column is
a marker. Must have length(P) rows.}

\item{...}{Other parameters to be passed into the rpart function}
}
\value{
Returns a object created by rpart function. Also plots a graph of
  decision tree.
}
\description{
A function that sse decision tree to find a group of cells that are
associated with clinical outcome.
}
\examples{
# Find the table containing fcs file names in CytoDx package
path=system.file("extdata",package="CytoDx")
# read the table
fcs_info <- read.csv(file.path(path,"fcs_info.csv"))
# Specify the path to the cytometry files
fn <- file.path(path,fcs_info$fcsName)
# Read cytometry files using fcs2DF function
train_data <- fcs2DF(fcsFiles=fn,
                    y=fcs_info$Label,
                    assay="FCM",
                    b=1/150,
                    excludeTransformParameters=
                      c("FSC-A","FSC-W","FSC-H","Time"))
# build the model
fit <- CytoDx.fit(x=as.matrix(train_data[,1:7]),
                y=train_data$y,
                xSample = train_data$xSample,
                reg=FALSE,
                family="binomial")
# check accuracy for training data
pred <- CytoDx.pred(fit,
                   xNew=as.matrix(train_data[,1:7]),
                   xSampleNew=train_data$xSample)

boxplot(pred$xNew.Pred.sample$y.Pred.s0~
          fcs_info$Label)

# Find the associated population using treeGate
TG <- treeGate(P = fit$train.Data.cell$y.Pred.s0,
              x= train_data[,1:7])
}
