% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cytoflexmix.R
\name{plot.cytoflexmix}
\alias{plot.cytoflexmix}
\title{Plot all components of mixture regression}
\usage{
\method{plot}{cytoflexmix}(x, k = NULL, separate = FALSE, ...)
}
\arguments{
\item{x}{A \code{cytoflexmix} class}

\item{k}{Number of clusters}

\item{separate}{create two separate \code{\link[ggplot2]{ggplot2}} objects}

\item{...}{Other parameters}
}
\value{
\code{\link[ggplot2]{ggplot2}} object
}
\description{
Plot all components of mixture regression
}
\examples{
set.seed(23)
df <- generate_data()
protein_names <- names(df)[3:12]
df <- dplyr::mutate_at(df, protein_names, function(x) asinh(x/5))
mix_fit <- CytoGLMM::cytoflexmix(df,
                                 protein_names = protein_names,
                                 condition = "condition",
                                 group = "donor",
                                 ks = 2)
plot(mix_fit)
}
