% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cytogroup.R
\name{plot.cytogroup}
\alias{plot.cytogroup}
\title{Plot fixded coefficients of group-specific fixed effects model}
\usage{
\method{plot}{cytogroup}(x, order = FALSE, separate = FALSE, ...)
}
\arguments{
\item{x}{A \code{cytoglmm} class}

\item{order}{Order the markers according to the mangintute of the
coefficients}

\item{separate}{create two separate \code{\link[ggplot2]{ggplot2}} objects}

\item{...}{Other parameters}
}
\value{
\code{\link[ggplot2]{ggplot2}} object
}
\description{
Plot fixded coefficients of group-specific fixed effects model
}
\examples{
set.seed(23)
df <- generate_data()
protein_names <- names(df)[3:12]
df <- dplyr::mutate_at(df, protein_names, function(x) asinh(x/5))
group_fit <- CytoGLMM::cytogroup(df,
                                 protein_names = protein_names,
                                 condition = "condition",
                                 group = "donor")
plot(group_fit)
}
