% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_heatmap.R
\name{plot_heatmap}
\alias{plot_heatmap}
\title{Heatmap of median marker expression}
\usage{
plot_heatmap(
  df_samples,
  sample_info_names,
  protein_names,
  arrange_by_1,
  arrange_by_2 = "",
  cluster_cols = FALSE,
  fun = median
)
}
\arguments{
\item{df_samples}{Data frame or tibble with proteins counts,
cell condition, and group information}

\item{sample_info_names}{Column names that contain information about
the cell, e.g. donor, condition, file name, or cell type}

\item{protein_names}{A vector of column names of protein to use in the
analysis}

\item{arrange_by_1}{Column name}

\item{arrange_by_2}{Column name}

\item{cluster_cols}{Apply hierarchical cluster to columns}

\item{fun}{Summary statistics of marker expression}
}
\value{
\code{\link[pheatmap]{pheatmap}} object
}
\description{
Heatmap of median marker expression
}
\examples{
set.seed(23)
df <- generate_data()
protein_names <- names(df)[3:12]
df <- dplyr::mutate_at(df, protein_names, function(x) asinh(x/5))
CytoGLMM::plot_heatmap(df,
                       protein_names = protein_names,
                       sample_info_names = c("donor", "condition"),
                       arrange_by_1 = "condition")
}
