% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{CytoPipelineCheckApp}
\alias{CytoPipelineCheckApp}
\title{interactive visualization of flow cytometry data analysis pipeline
objects stored in cache}
\usage{
CytoPipelineCheckApp(dir = ".", debug = FALSE)
}
\arguments{
\item{dir}{the root directory into which the engine will look for existing
CytoPipeline experiments}

\item{debug}{if TRUE, will output messages on the console tracking the
shiny events, for debugging purposes}
}
\value{
no return value
}
\description{
interactive visualization of flow cytometry data analysis pipeline
objects stored in cache
}
\examples{

# run CytoPipeline object first

outputDir <- base::tempdir()


rawDataDir <-
    system.file("extdata", package = "CytoPipeline")
experimentName <- "OMIP021_PeacoQC"
sampleFiles <- 
    file.path(
        rawDataDir, 
        list.files(
            rawDataDir, 
            pattern = "Donor"))
jsonDir <- system.file("extdata", package = "CytoPipeline")
jsonPath <- file.path(jsonDir, "pipelineParams.json")

pipL2 <- CytoPipeline(
    jsonPath,
    experimentName = experimentName,
    sampleFiles = sampleFiles)

suppressWarnings(execute(
    pipL2,
    rmCache = TRUE,
    path = outputDir))

# run shiny app

if (interactive())
    CytoPipelineCheckApp(dir = outputDir)                    

}
