% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CytoProcessingStepImplementations.R
\name{applyScaleTransforms}
\alias{applyScaleTransforms}
\title{apply scale transforms}
\usage{
applyScaleTransforms(x, transList, verbose = FALSE, ...)
}
\arguments{
\item{x}{a flowCore::flowSet or a flowCore::flowFrame}

\item{transList}{a flowCore::transformList}

\item{verbose}{if TRUE, send a message per flowFrame transformed}

\item{...}{other arguments (not used)}
}
\value{
the transformed flowFrame
}
\description{
wrapper around flowCore::transform() that discards any
additional parameter passed in (...)
Additionally, some checks regarding channels correspondance is done:
if \code{transList} contains transformations for channels that are not present
in \code{x}, then these transformations are first removed.
}
\examples{

data(OMIP021Samples)

transListPath <- file.path(system.file("extdata", 
                                       package = "CytoPipeline"),
                           "OMIP021_TransList.rds") 

transList <- readRDSObject(transListPath)

ff_c <- compensateFromMatrix(OMIP021Samples[[1]],
                             matrixSource = "fcs")  

ff_t <- applyScaleTransforms(ff_c, transList = transList)

}
