% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{computeScatterChannelsLinearScale}
\alias{computeScatterChannelsLinearScale}
\title{compute linear transformation of scatter channels found in ff, based
on 5\% and 95\% of referenceChannel, set as target. If there is a
transformation defined in transList for referenceChannel, it is applied
first, before computing quantiles.
Then the computed linear transformations (or each scatter channel) are added
into the transfo_list. -A channels are computed, and same linear
transformation is then applied to corresponding -W and -H channels
(if they exist in ff).}
\usage{
computeScatterChannelsLinearScale(
  ff,
  transList = NULL,
  referenceChannel,
  silent = TRUE
)
}
\arguments{
\item{ff}{a flowCore::flowFrame}

\item{transList}{an initial flowCore::transformList}

\item{referenceChannel}{the reference channel to take target quantile values
from. Can be defined as marker or channel name.}

\item{silent}{if FALSE, will output some information on the computed
linear transformations}
}
\value{
the transList with added linear scale transformations
}
\description{
based on a referenceChannel
}
\examples{

data(OMIP021Samples)

ff <- OMIP021Samples[[1]]
refMarker <- "APCCy7 - CD4"
refChannel <- "780/60Red-A"
transList <- flowCore::estimateLogicle(ff,
                                       channels = refChannel)
retTransList <-
    computeScatterChannelsLinearScale(ff,
                                      transList = transList,
                                      referenceChannel = refMarker,
                                      silent = TRUE
    )
}
