% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CytoProcessingStepImplementations.R
\name{qualityControlPeacoQC}
\alias{qualityControlPeacoQC}
\title{perform QC with PeacoQC}
\usage{
qualityControlPeacoQC(
  ff,
  preTransform = FALSE,
  transList = NULL,
  outputDiagnostic = FALSE,
  outputDir = NULL,
  ...
)
}
\arguments{
\item{ff}{a flowCore::flowFrame}

\item{preTransform}{if TRUE, apply the transList scale transform prior to
running the gating algorithm}

\item{transList}{applied in conjunction with preTransform}

\item{outputDiagnostic}{if TRUE, stores diagnostic files generated by
PeacoQC in outputDir directory}

\item{outputDir}{used in conjunction with outputDiagnostic}

\item{...}{additional parameters passed to PeacoQC::PeacoQC()}
}
\value{
a flowCore::flowFrame with removed low quality events from the input
}
\description{
this function is a wrapper around PeacoQC::PeacoQC()
function.
It also pre-selects the channels to be handled (=> all signal channels)
}
\examples{

rawDataDir <-
    system.file("extdata", package = "CytoPipeline")
sampleFiles <-
    file.path(rawDataDir, list.files(rawDataDir, pattern = "Donor"))

truncateMaxRange <- FALSE
minLimit <- NULL

# create flowCore::flowSet with all samples of a dataset
fsRaw <- readSampleFiles(
    sampleFiles = sampleFiles,
    whichSamples = "all",
    truncate_max_range = truncateMaxRange,
    min.limit = minLimit)

suppressWarnings(ff_m <- removeMarginsPeacoQC(x = fsRaw[[2]]))
    
ff_c <-
    compensateFromMatrix(ff_m,
                         matrixSource = "fcs")        

transList <- 
    estimateScaleTransforms(        
        ff = ff_c,
        fluoMethod = "estimateLogicle",
        scatterMethod = "linear",
        scatterRefMarker = "BV785 - CD3")


ff_QualityControl <- suppressWarnings(
    qualityControlPeacoQC(
        ff_c,
        preTransform = TRUE,
        transList = transList,
        min_cells = 150,
        max_bins = 500,
        MAD = 6,
        IT_limit = 0.55,
        force_IT = 150, 
        peak_removal = (1/3),
        min_nr_bins_peakdetection = 10))
        
}
