% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tstats.R
\name{get_tstats}
\alias{get_tstats}
\title{Get t-Statistics}
\usage{
get_tstats(
  sa,
  design,
  contrast = NULL,
  method = "ls",
  trend = FALSE,
  smooth = FALSE,
  maxGap = 20,
  coef = 2,
  verbose = TRUE,
  filter = TRUE,
  ...
)
}
\arguments{
\item{sa}{A SummarizedExperiment containing ASM values where each row and
column correspond to a tuple/site and sample respectively.}

\item{design}{a design matrix created with \code{\link{model.matrix}}.}

\item{contrast}{a contrast matrix, generated with
\code{\link{makeContrasts}}.}

\item{method}{The method to be used in limma's \code{\link{lmFit}}. The
default is set to 'ls' but can also be set to 'robust', which is
recommended on a real data set.}

\item{trend}{Passed to \code{\link{eBayes}}. Should an intensity-trend be
allowed for the prior variance? Default is that the prior variance is
constant, e.g. FALSE.}

\item{smooth}{Whether smoothing should be applied to the t-Statistics.
Default = FALSE. If TRUE, wherever smoothing is not possible, the
un-smoothed t-stat is used instead.}

\item{maxGap}{The maximum allowed gap between genomic positions for
clustering of genomic regions to be used in smoothing. Default = 20.}

\item{coef}{Column in model.matrix specifying the parameter to estimate.
Default = 2. If \code{contrast} specified, column with contrast of interest.}

\item{verbose}{Set verbose. Default = TRUE.}

\item{filter}{Remove empty tstats. Default = TRUE.}

\item{...}{Arguments passed to \code{\link{loessByCluster}}. Only used if
\code{smooth} = TRUE.}
}
\value{
A vector of t-Statistics within the
  \code{RangedSummarizedExperiment}.
}
\description{
This function calculates a moderated t-Statistic per site or tuple using
\code{limma}'s \code{\link{lmFit}} and \code{\link{eBayes}} functions. It
then smoothes the obtained t-Statistics using \code{bumphunter}'s
\code{\link{smoother}} function.
}
\details{
The smoothing is done on genomic clusters consisting of CpGs that are close
to each other. In the case of tuples, the midpoint of the two genomic
positions in each tuple is used as the genomic position of that tuple, to
perform the smoothing.The function takes a \code{RangedSummarizedExperiment}
generated by \code{\link{calc_derivedasm}} or \code{\link{calc_asm}}
containing ASM across samples, and the index of control and treatment
samples.
}
\examples{
data(readtuples_output)
ASM <- calc_asm(readtuples_output)
grp <- factor(c(rep('CRC',3),rep('NORM',2)), levels = c('NORM', 'CRC'))
mod <- model.matrix(~grp)
tstats <- get_tstats(ASM, mod)

}
