% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missingValuesFilter.R
\name{MetaCellFiltering}
\alias{MetaCellFiltering}
\title{Filter lines in the matrix of intensities w.r.t. some criteria}
\usage{
MetaCellFiltering(obj, indices, cmd, processText = "")
}
\arguments{
\item{obj}{An object of class \code{MSnSet} containing
quantitative data.}

\item{indices}{A vector of integers which are the indices of lines to
keep.}

\item{cmd}{xxxx. Available values are: 'delete', 'keep'.}

\item{processText}{A string to be included in the \code{MSnSet}
object for log.}
}
\value{
An instance of class \code{MSnSet} that have been filtered.
}
\description{
#' Filters the lines of \code{Biobase::exprs()} table with conditions on the 
number of missing values.
The user chooses the minimum amount of intensities that is acceptable and
the filter delete lines that do not respect this condition.
The condition may be on the whole line or condition by condition.

The different methods are :
"WholeMatrix": given a threshold \code{th}, only the lines that contain
at least \code{th} values are kept.
"AllCond": given a threshold \code{th}, only the lines which contain
at least \code{th} values for each of the conditions are kept.
"AtLeastOneCond": given a threshold \code{th}, only the lines that contain
at least \code{th} values, and for at least one condition, are kept.
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
obj <- Exp1_R25_pept[seq_len(100)]
level <- 'peptide'

#' 
#' Delete lines which are entirely filled with any missing values ('Missing MEC' and 'Missing POV')
metacell.mask <- match.metacell(GetMetacell(obj), c("Missing POV", "Missing MEC"), level)
indices <- GetIndices_WholeLine(metacell.mask)
obj.filter <- MetaCellFiltering(obj, indices, "delete")


obj <- obj[1:10]

pattern <- "Quantified"
type <- "AtLeastOneCond"
percent <- FALSE
op <- ">="
th <- 3
indices <- GetIndices_MetacellFiltering(obj, level, pattern, type, percent, op, th)
obj <- MetaCellFiltering(obj, indices, "keep")$new
#fData(obj)[, obj@experimentData@other$names_metacell]

pattern <- "Quant. by direct id"
type <- "AtLeastOneCond"
percent <- FALSE
op <- ">="
th <- 3
indices <- GetIndices_MetacellFiltering(obj, level, pattern, type, percent, op, th)
obj <- MetaCellFiltering(obj, indices, "keep")$new
#fData(obj)[, obj@experimentData@other$names_metacell]
names.1 <- rownames(obj)


obj <- Exp1_R25_pept[seq_len(100)]
pattern <- "Quant. by direct id"
type <- "AtLeastOneCond"
percent <- FALSE
op <- ">="
th <- 3
indices <- GetIndices_MetacellFiltering(obj, level, pattern, type, percent, op, th)
obj <- MetaCellFiltering(obj, indices, "keep")$new
#fData(obj)[, obj@experimentData@other$names_metacell]

pattern <- "Quantified"
type <- "AtLeastOneCond"
percent <- FALSE
op <- ">="
th <- 3
indices <- GetIndices_MetacellFiltering(obj, level, pattern, type, percent, op, th)
obj <- MetaCellFiltering(obj, indices, "keep")$new
#fData(obj)[, obj@experimentData@other$names_metacell]
names.2 <- rownames(obj)
}
\author{
Florence Combes, Samuel Wieczorek
}
