% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agregation.R
\name{aggregateMean}
\alias{aggregateMean}
\title{Compute the intensity of proteins as the mean of the intensities
of their peptides.}
\usage{
aggregateMean(obj.pep, X)
}
\arguments{
\item{obj.pep}{A peptide object of class \code{MSnset}}

\item{X}{An adjacency matrix in which lines and columns correspond
respectively to peptides and proteins.}
}
\value{
A matrix of intensities of proteins
}
\description{
#' This function computes the intensity of proteins as the mean of the
intensities of their peptides.
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
obj.pep <- Exp1_R25_pept[seq_len(10)]
obj.pep.imp <- wrapper.impute.detQuant(obj.pep, na.type = c("Missing POV", "Missing MEC"))
protID <- "Protein_group_IDs"
X <- BuildAdjacencyMatrix(obj.pep.imp, protID, FALSE)
ll.agg <- aggregateMean(obj.pep.imp, X)

}
\author{
Alexia Dorffer
}
