% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{checkClusterability}
\alias{checkClusterability}
\title{xxx}
\usage{
checkClusterability(standards, b = 500)
}
\arguments{
\item{standards}{a matrix or dataframe containing only the standardized
mean intensities returned by the function [standardiseMeanIntensities()]}

\item{b}{Parameter B of the function [gap_cluster()]}
}
\value{
a list of 2 elements:
* dip_test: the result of the clusterability of the data
* gap_cluster: the gap statistic obtained with the function
[cluster::clusGap()].
}
\description{
The first step is to standardize the data (with the \code{Mfuzz}
package). Then the function checks that these data are clusterizable or not
(use of [diptest::dip.test()] to determine whether the distribution is
unimodal or multimodal). Finally, it determines the "optimal" k by
the Gap statistic approach.
}
\examples{
data(Exp1_R25_prot, package="DAPARdata")
obj <- Exp1_R25_prot[seq_len(100)]
level <- 'protein'
metacell.mask <- match.metacell(GetMetacell(obj), c("Missing POV", "Missing MEC"), level)
indices <- GetIndices_WholeMatrix(metacell.mask, op = ">=", th = 1)
obj <- MetaCellFiltering(obj, indices, cmd = "delete")
averaged_means <- averageIntensities(obj$new)
only_means <- dplyr::select_if(averaged_means, is.numeric)
only_features <- dplyr::select_if(averaged_means, is.character)
means <- purrr::map(purrr::array_branch(as.matrix(only_means), 1), mean)
centered <- only_means - unlist(means)
centered_means <- dplyr::bind_cols(
feature = dplyr::as_tibble(only_features),
dplyr::as_tibble(centered))
checkClust <- checkClusterability(centered_means, b = 100)
}
\author{
Helene Borges
}
