% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr.R
\name{arrange.DataFrame}
\alias{arrange.DataFrame}
\title{Order rows using column values}
\usage{
\method{arrange}{DataFrame}(.data, ...)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Variables, or
functions of variables. Use \code{\link[dplyr:desc]{desc()}} to sort a variable in descending
order.}
}
\value{
An object of the same type as \code{.data}. The output has the following
properties:
\itemize{
\item All rows appear in the output, but (usually) in a different place.
\item Columns are not modified.
\item Groups are not modified.
\item Data frame attributes are preserved.
}
}
\description{
\code{arrange()} orders the rows of a data frame by the values of selected
columns.

Unlike other dplyr verbs, \code{arrange()} largely ignores grouping; you
need to explicitly mention grouping variables (or use  \code{.by_group = TRUE})
in order to group by them, and functions of variables are evaluated
once per data frame, not once per group.
}
\details{
\subsection{Missing values}{

Unlike base sorting with \code{sort()}, \code{NA} are:
\itemize{
\item always sorted to the end for local data, even when wrapped with \code{desc()}.
\item treated differently for remote data, depending on the backend.
}
}
}
\section{Methods}{


This function is a \strong{generic}, which means that packages can provide
implementations (methods) for other classes. See the documentation of
individual methods for extra arguments and differences in behaviour.

The following methods are currently available in loaded packages:
\Sexpr[stage=render,results=rd]{dplyr:::methods_rd("arrange")}.

}

\examples{
arrange(mtcars, cyl, disp)
arrange(mtcars, desc(disp))

# grouped arrange ignores groups
by_cyl <- mtcars \%>\% group_by(cyl)
by_cyl \%>\% arrange(desc(wt))
# Unless you specifically ask:
by_cyl \%>\% arrange(desc(wt), .by_group = TRUE)

# use embracing when wrapping in a function;
# see ?rlang::args_data_masking for more details
tidy_eval_arrange <- function(.data, var) {
  .data \%>\%
    arrange({{ var }})
}
tidy_eval_arrange(mtcars, mpg)

# Use `across()` or `pick()` to select columns with tidy-select
iris \%>\% arrange(pick(starts_with("Sepal")))
iris \%>\% arrange(across(starts_with("Sepal"), desc))
}
\seealso{
Other single table verbs: 
\code{\link[dplyr]{filter}()},
\code{\link[dplyr]{mutate}()},
\code{\link[dplyr]{reframe}()},
\code{\link[dplyr]{rename}()},
\code{\link[dplyr]{select}()},
\code{\link[dplyr]{slice}()},
\code{\link[dplyr]{summarise}()}
}
