% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateTgrid.R
\name{estimateThreshold}
\alias{estimateThreshold}
\alias{estimateWindowThreshold}
\title{EstimateWindowThresholds}
\usage{
estimateWindowThreshold(nProbe, windowSize, method = "siegmund",
  mcmc = 1000, nCPU = 1, submethod = "ar", ...)
}
\arguments{
\item{nProbe}{The number of probes (CpGs) in the study.}

\item{windowSize}{The different window sizes to be tested. 
Must be either one, or an ordered sequence of integers.}

\item{method}{Gives the method by which the threshold is calculated. 
Can be either an analytical solution "siegmund", provided by 
Siegnumd et.al (2012), or an iterative process; either importance 
sampling "sampling", as suggested by Zhang (2012) or a full MCMC model 
"mcmc" which can account for any dependency structure,  wich is pass 
to arima.sim, with ...}

\item{mcmc}{The number of MCMC iterations to be used, when using either 
Important Sampling ("zhang") or MCMC estimation of the threshold.}

\item{nCPU}{When calculating the thresholds on a cluster, how many CPUs 
should be used. This option is only compatible with the 'mcmc' method.}

\item{submethod}{A character string indicating if an AR(5) or ARIMA model 
should be used. In the AR(5), the index runs from -2 to 2. A regular AR(p) 
model can be obtaine using ARIMA(p,0,0) instead.}

\item{...}{Optinal parameters pased on to \code{\link[stats]{arima}}, when simulating data 
using the mcmc option, see arima.sim()}
}
\value{
Returns a vector of the threshold for each window size
}
\description{
Estimate window thresholds for sliding window, 
one unique value for each window size
}
\examples{
thresholdGrid <- estimateWindowThreshold(nProbe = 1000, 
                                    windowSize = 3:8, method = "siegmund")
}
