% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DNAfusion_functions.R
\name{EML4_ALK_analysis}
\alias{EML4_ALK_analysis}
\title{Complete EML4-ALK analysis}
\usage{
EML4_ALK_analysis(file, genome = "hg38", mates = 2, basepairs = 20)
}
\arguments{
\item{file}{The name of the file which the data are to be read from.}

\item{genome}{\code{character} representing the reference genome.
Can be either "hg38" or "hg19". Default="hg38".}

\item{mates}{\code{interger}, the minimum number EML4-ALK mate pairs needed
to be detected in order to call a variant. Default=2.}

\item{basepairs}{\code{integer}, number of basepairs identified
from the EML4-ALK fusion. Default=20.}
}
\value{
A \code{list} object with
clipped_reads corresponding to \code{EML4_ALK_detection()},
last_EML4 corresponding to \code{EML4_sequence()},
first_ALK corresponding to \code{ALK_sequence()},
breakpoint_ALK corresponding to \code{break_position()}, gene = "ALK",
breakpoint_EML4 corresponding to \code{break_position()},gene = "EML4",
read_depth_ALK corresponding to \code{break_position_depth()}.gene = "ALK",
and read_depth_EML4 corresponding to \code{break_position_depth()}
,gene = "EML4".
If no EML4-ALK is detected an empty \code{GAlignments} is returned.
}
\description{
This functions collects the results from the other functions of the package.
}
\examples{
H3122_bam <- system.file("extdata",
"H3122_EML4.bam",
package="DNAfusion")
HCC827_bam <-  system.file("extdata",
"HCC827_EML4.bam",
package="DNAfusion")

EML4_ALK_analysis(file=H3122_bam,
                    genome="hg38",
                    mates=2,
                    basepairs=20)
EML4_ALK_analysis(file=HCC827_bam,
                    genome="hg38",
                    mates=2,
                    basepairs=20)
}
