% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{DOUData-class}
\alias{DOUData-class}
\title{DOUData-class}
\description{
A \code{RangedSummarizedExperiment} object extended to store modeling
components for Differential ORF Usage (DOU) analysis in the
\pkg{DOTSeq} framework.
}
\details{
This class contains raw counts, sample metadata, and additional slots
for the model formula, \code{\link[emmeans]{emmeans}} specifications,
and contrast results. It supports flexible modeling of
translation-specific effects using GLM / GLMM and post hoc contrasts.
}
\section{Slots}{

\describe{
\item{\code{formula}}{A \code{formula} object specifying the model design
(e.g., ~ condition * strategy).}

\item{\code{specs}}{A \code{formula} object used to generate
\code{\link[emmeans]{emmeans}} specifications for post hoc contrasts.}

\item{\code{interaction}}{A \code{DFrame} containing results
from interaction-specific contrasts.}

\item{\code{strategy}}{A \code{DFrame} containing results
from strategy-specific contrasts.}
}}

\examples{
# Read in count matrix, condition table, and annotation files
dir <- system.file("extdata", package = "DOTSeq")

cnt <- read.table(
    file.path(dir, "featureCounts.cell_cycle_subset.txt.gz"),
    header = TRUE,
    comment.char = "#"
)
names(cnt) <- gsub(".*(SRR[0-9]+).*", "\\\\1", names(cnt))

flat <- file.path(dir, "gencode.v47.orf_flattened_subset.gtf.gz")
bed <- file.path(dir, "gencode.v47.orf_flattened_subset.bed.gz")

meta <- read.table(file.path(dir, "metadata.txt.gz"))
names(meta) <- c("run", "strategy", "replicate", "treatment", "condition")
cond <- meta[meta$treatment == "chx", ]
cond$treatment <- NULL

# Create a DOTSeqDataSets object
d <- DOTSeqDataSetsFromFeatureCounts(
    count_table = cnt,
    condition_table = cond,
    flattened_gtf = flat,
    flattened_bed = bed
)

getDOU(d)

getDTE(d)

}
\seealso{
\code{\link[SummarizedExperiment]{RangedSummarizedExperiment}},
\code{\link[glmmTMB]{glmmTMB}}, \code{\link[emmeans]{emmeans}}
}
