% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{calculate_mean_dispersion}
\alias{calculate_mean_dispersion}
\title{Calculate Moment-Based Dispersion Estimate}
\usage{
calculate_mean_dispersion(counts, totals)
}
\arguments{
\item{counts}{A numeric vector of ORF counts across samples.}

\item{totals}{A numeric vector of total gene counts across the same samples.}
}
\value{
A \code{list} containing:
\describe{
\item{mean_prop}{
Mean proportion of ORF counts relative to total gene counts.
}
\item{rawRho}{
Unclamped dispersion estimate (can be negative).
}
\item{raw_intra_class_corr}{
Clamped dispersion estimate (non-negative).
}
}
}
\description{
This helper function computes a moment-based estimate of dispersion
(intra-class correlation) for a given set of ORF counts and total gene
counts across samples. It avoids division by zero and clamps negative
dispersion estimates to zero.
}
\keyword{internal}
