% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runtime.R
\name{extract_results}
\alias{extract_results}
\title{Extract Model Results into a Unified Data Frame}
\usage{
extract_results(sumExp, verbose = TRUE)
}
\arguments{
\item{sumExp}{A SummarizedExperiment object containing fitted model
objects stored in \code{rowData(sumExp)[['DOUResults']]}.}

\item{verbose}{Logical. If \code{TRUE}, messages will be printed
for skipped or failed models.}
}
\value{
A data frame where each row corresponds to an ORF and its
associated model results. Columns include scalar parameters
extracted from the model, \code{orf_id}, and \code{model_type}.
}
\description{
Extracts scalar results from a named list of model objects
from \code{glmmTMB} fits into a tidy data frame. Handles nested lists,
missing or \code{NULL} models, and ensures consistent columns across
all entries.
}
\details{
The function uses a recursive helper (\code{flatten_scalars}) to extract
scalar values from nested lists. It supports model type
\code{"glmmTMB"}, and gracefully handles \code{NULL} or unsupported
model types by returning minimal rows.

Missing columns across models are filled with \code{NA} to ensure a
consistent structure.
}
\keyword{internal}
