% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation.R
\name{filter_gtf}
\alias{filter_gtf}
\title{Filter GTF file for transcript features with required metadata}
\usage{
filter_gtf(
  gtf_file,
  require_ids = c("hgnc_id", "protein_id", "ccdsid"),
  source_filter = NULL,
  verbose = TRUE
)
}
\arguments{
\item{gtf_file}{Character. Path to the GTF file.}

\item{require_ids}{Character vector. Metadata column names that must
be present and non-NA. Default: \code{c("hgnc_id", "protein_id", 
"ccdsid")}.}

\item{source_filter}{Character or NULL. If provided, filters
transcripts by the 'source' column. Default: \code{NULL}.}

\item{verbose}{Logical. Whether to print summary messages.
Default: \code{TRUE}.}
}
\value{
A filtered \code{GRanges} object containing transcript
features.
}
\description{
This function imports a GTF file and filters transcript features
based on the presence of required metadata columns and an optional
source filter.
}
\keyword{internal}
