% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{generate_coefficients}
\alias{generate_coefficients}
\title{Generate Coefficients for Simulated Differential ORF Translation}
\usage{
generate_coefficients(
  orfs,
  scenario = "uORF_up_mORF_down",
  gcoeff = 1.5,
  shape = 0.6,
  scale = 0.5
)
}
\arguments{
\item{orfs}{A data frame containing ORF annotations. Row names must align
with the filtered count matrices. Must include columns
\code{gene_id} and \code{orf_type}.}

\item{scenario}{A character string specifying the regulatory scenario to
simulate. Must be one of:
\itemize{
\item \code{"uORF_up_mORF_down"}
\item \code{"dORF_up_mORF_up"}
\item \code{"uORF_up_mORF_flat"}
\item \code{"uORF_down_mORF_flat"}
\item \code{"uORF_down_mORF_down"}
\item \code{"uORF_down_mORF_up"}
\item \code{"uORF_flat_mORF_up"}
\item \code{"uORF_flat_mORF_down"}
\item \code{"dORF_up_mORF_down"}
\item \code{"dORF_up_mORF_flat"}
\item \code{"dORF_down_mORF_flat"}
\item \code{"dORF_down_mORF_down"}
\item \code{"dORF_down_mORF_up"}
\item \code{"dORF_flat_mORF_up"}
\item \code{"dORF_flat_mORF_down"}
}}

\item{gcoeff}{Numeric. The log-fold change magnitude to apply to regulated
ORFs.}

\item{shape}{Numeric. Shape parameter for the gamma distribution used to
simulate baseline coefficients.}

\item{scale}{Numeric. Scale parameter for the gamma distribution used to
simulate baseline coefficients.}
}
\value{
A list with the following components:
\describe{
\item{gcoeffs_ribo}{Named numeric vector of log-fold change
coefficients for ribosome profiling data.}
\item{gcoeffs_rna}{Named numeric vector of baseline log-fold
change coefficients for RNA-seq data.}
\item{labels}{Named binary vector indicating truly regulated
ORFs (\code{1}) vs. non-regulated (\code{0}).}
}
}
\description{
Simulates log-fold change coefficients for differential ORF translation
(DOT) analysis. This function assigns baseline coefficients to all ORFs
and applies specific log-fold changes to multi-cistronic ORFs based on a
selected regulatory scenario.
}
\examples{
\dontrun{
generate_coefficients(orfs_df, scenario = "uORF_up_mORF_down")
}

}
\keyword{internal}
