% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation.R
\name{longestORFs}
\alias{longestORFs}
\title{Get longest ORF per stop site}
\usage{
longestORFs(grl)
}
\arguments{
\item{grl}{a \code{\link[GenomicRanges]{GRangesList}}/IRangesList, GRanges/IRanges of ORFs}
}
\value{
a \code{\link[GenomicRanges]{GRangesList}}/IRangesList, GRanges/IRanges
(same as input)
}
\description{
Rule: if seqname, strand and stop site is equal, take longest one.
Else keep.
If IRangesList or IRanges, seqnames are groups, if GRanges or GRangesList
seqnames are the seqlevels (e.g. chromosomes/transcripts)
}
\examples{
\dontrun{
ORF1 = GRanges("1", IRanges(10,21), "+")
ORF2 = GRanges("1", IRanges(1,21), "+") # <- longest
grl <- GRangesList(ORF1 = ORF1, ORF2 = ORF2)
longestORFs(grl) # get only longest
}

}
\references{
Tjeldnes, H., Labun, K., Torres Cleuren, Y. et al.
ORFik: a comprehensive R toolkit for the analysis of translation.
BMC Bioinformatics 22, 336 (2021). DOI: 10.1186/s12859-021-04254-w
}
\seealso{
Other ORFHelpers: 
\code{\link{stopSites}()}
}
\author{
Haakon Tjeldnes et al.
}
\concept{ORFHelpers}
\keyword{internal}
