% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{match_runs}
\alias{match_runs}
\title{Match and align sample metadata with count table}
\usage{
match_runs(cnt, cond, num_feat_cols = 0, baseline = NULL, verbose = TRUE)
}
\arguments{
\item{cnt}{A data frame containing count data. Columns must include sample
names matching the \code{run} column in \code{cond}. If \code{num_feat_cols}
is 6, the first six columns must be: \code{Geneid}, \code{Chr}, \code{Start},
\code{End}, \code{Strand}, \code{Length}.}

\item{cond}{A data frame containing sample metadata. Must include columns:
\code{run}, \code{strategy}, \code{condition}, and \code{replicate}.}

\item{num_feat_cols}{Integer specifying the number of feature columns in
\code{cnt} before sample columns. Typically 6 for featureCounts output,
or 0 for raw count matrices.}

\item{baseline}{Optional character string specifying the reference level
for the \code{condition} factor.}
}
\value{
A list with two elements:
\describe{
\item{\code{cnt}}{A reordered count table with renamed sample columns.}
\item{\code{cond}}{A metadata data frame with binary strategy labels
and factor columns, ready for modeling.}
}
}
\description{
This internal function matches sample identifiers between the count table
and the condition table, ensuring consistency in sample naming and
ordering. It verifies that sufficient replicates exist, renames columns
to include metadata, and prepares the count and condition tables for
downstream differential translation analysis. It also assigns binary
strategy labels (e.g., RNA = 0, Ribo = 1), sets factor levels, and
optionally relevels the condition factor to a specified baseline.
}
\keyword{internal}
