% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_heatmap}
\alias{plot_heatmap}
\title{Plot Heatmap for Differential ORF Usage (DOU)}
\usage{
plot_heatmap(paired_data)
}
\arguments{
\item{paired_data}{A named list containing heatmap data and metadata,
typically the output from \code{cistronic_data()}. Must include the
following elements:
\describe{
\item{ordered_matrix}{
Matrix of DOU estimates for significant genes, ordered by
hierarchical clustering.
}
\item{row_dend_clean}{
Dendrogram object for clustered gene rows.
}
\item{highlight_df}{
Data frame indicating which ORF-gene tiles to highlight in
the heatmap.
}
\item{gene_labels}{
Vector of gene symbols or Ensembl IDs for heatmap row labeling.
}
\item{color_palette}{
Color palette used for heatmap visualization.
}
\item{color_breaks}{
Breaks used for color scaling in the heatmap.
}
\item{abs_max}{
Maximum absolute value used for symmetric color scaling.
}
}}
}
\value{
A heatmap with a dendrogram and color key.
}
\description{
Generates a heatmap of differential ORF usage (DOU) estimates with
hierarchical clustering and optional tile highlighting for significant ORFs.
The function uses base R graphics and expects all required inputs to be
passed via a named list produced by \code{cistronic_data()}.
}
\details{
The heatmap displays log-odds changes in ORF usage across genes, comparing
mORFs with short ORFs (e.g., uORFs or dORFs). Significant ORFs are
highlighted using rectangles. The color scale is symmetric and centered at
zero. The function uses base R plotting functions and is intended for
interactive or scripted visualization.
}
\keyword{internal}
