% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runtime.R
\name{runtime}
\alias{runtime}
\title{Format elapsed time between two timestamps}
\usage{
runtime(end_time, start_time, units = "secs")
}
\arguments{
\item{end_time}{POSIXct. The end time of the process.}

\item{start_time}{POSIXct. The start time of the process.}

\item{units}{Character. Units for \code{difftime()} calculation.
Default is \code{"secs"}.}
}
\value{
A named list containing:
\itemize{
\item \code{mins} (optional) — integer number of minutes
\item \code{secs} — integer number of seconds
}
}
\description{
Computes the elapsed time between a start and end timestamp, returning
a list with minutes and seconds. If the duration is less than one
minute, only seconds are returned. Useful for logging runtimes in a
human-readable format.
}
\examples{
\dontrun{
    start <- Sys.time()
    Sys.sleep(3.5)
    end <- Sys.time()
    runtime(end, start)
}

}
\keyword{internal}
