% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation.R
\name{sortPerGroup}
\alias{sortPerGroup}
\title{Sort a GRangesList}
\usage{
sortPerGroup(grl, ignore.strand = FALSE, quick.rev = FALSE)
}
\arguments{
\item{grl}{a \code{\link[GenomicRanges]{GRangesList}}}

\item{ignore.strand}{a boolean, (default FALSE): should minus strands be
sorted from highest to lowest ends. If TRUE: from lowest to highest ends.}

\item{quick.rev}{default: FALSE, if TRUE, given that you know all ranges are
sorted from min to max for both strands, it will only reverse coordinates for
minus strand groups, and only if they are in increasing order. Much quicker}
}
\value{
an equally named GRangesList, where each group is
sorted within group.
}
\description{
A faster, more versatile reimplementation of
\code{\link[GenomicRanges]{sort.GenomicRanges}} for GRangesList,
needed since the original works poorly for more than 10k groups.
This function sorts each group, where "+" strands are
increasing by starts and "-" strands are decreasing by ends.
}
\details{
Note: will not work if groups have equal names.
}
\references{
Tjeldnes, H., Labun, K., Torres Cleuren, Y. et al.
ORFik: a comprehensive R toolkit for the analysis of translation.
BMC Bioinformatics 22, 336 (2021). DOI: 10.1186/s12859-021-04254-w
}
\author{
Haakon Tjeldnes et al.
}
\keyword{internal}
