% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{RNAScope_prop}
\alias{RNAScope_prop}
\title{Cell Type Proportions estimated from RNAScope}
\format{
A \code{data.frame} object.
}
\source{
\url{https://github.com/LieberInstitute/DeconvoBuddies/blob/master/inst/extdata/data-raw/RNAScope_prop.R}
}
\usage{
data("RNAScope_prop")
}
\description{
Cell type proportion estimates from high quality images from
Huuki-Myers et al., bioRxiv, 2024,
doi: \url{https://doi.org/10.1101/2024.02.09.579665}.
}
\details{
11.49 kB

These are the columns of the \code{data.frame} object:
\itemize{
\item \code{SAMPLE_ID} : DLPFC Tissue block + RNAScope combination.
\item \code{Sample} : DLFPC Tissue block (Donor BrNum + DLPFC position).
\item \code{Combo} : RNAScope probe combination, either "Circle" marking cell types Astro
Endo, Inhib, or "Star" marking Excit, Micro, and OligoOPC.
\item \code{cell_type} : The cell type measured.
\item \code{Confidence} : Image confidence, this dataset has been filtered to the high & Ok confidence images.
\item \code{n_cell} : the number of cells counted for the Sample and cell type.
\item \code{prop} : the calculated cell type proportion from n_cell.
\item \code{n_cell_sn} : number of nuclei in the corresponding snRNA-seq data.
\item \code{prop_sn} : cell type proportion from the snRNA-seq data.
}

NOTE: For the RNAScope assay utilized here only 3 cell types could be measured
at once. Two consecutive tissue slices were used from each brain block to
measure one combination of three major cell types, then the other three
(differentiated as circle and star). DAPI was used to mark the nuclei, in
each tissue section, so the overall number of cells is recorded but only a
fraction has a cell type label, unlabeled nuclei are classified "other".

The two sections combined should get close to identifying the type of all the
cells, but often the combined "non-other" fractions are around 0.7 and not 1.
This could be due to a few reasons: the sections while as similar as
possible are not the same tissue, error in the assay and/or image processing
not labeling all cells possible, or presence of rare cell types not marked
by the selected probes.

With all of this considered, we still think the RNAScope estimates are good
approximations of the cell type proportions in these samples.

For more info check out \url{https://doi.org/10.1101/2024.02.09.579665} Figure 2,
and Methods: RNAScope/Immunofluorescence Data Generation and HALO Analysis.
}
\examples{
# To view source
system.file("extdata", "data-raw", "RNAScope_prop.R", package = "DeconvoBuddies")
}
\keyword{datasets}
