% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convDegCreResListToCreGeneScoreGR.R
\name{convDegCreResListToCreGeneScoreGR}
\alias{convDegCreResListToCreGeneScoreGR}
\title{Convert a degCreResList to a creGeneScoreGR}
\usage{
convDegCreResListToCreGeneScoreGR(
  degCreResList,
  scoreType = "assocProb",
  geneColname = "GeneSymb",
  onlyDEGs = TRUE,
  DEgAlpha = NULL,
  degPadjColname = "pAdj"
)
}
\arguments{
\item{degCreResList}{A \code{degCreResList}}

\item{scoreType}{Character of one of \code{assocProb}, \code{adjOR}, 
\code{rawAssocProb}. (Default:\code{assocProb})
See Details for a description of these options.}

\item{geneColname}{The name of the metadata column in \code{DegGR} in 
\code{degCreResList} that contains the gene names. 
(Default:\code{"GeneSymb"})}

\item{onlyDEGs}{Logical. If \code{TRUE}, only those associations involving
a gene with an adjusted p-value less than or equal to \code{DEgAlpha} are
returned. (Default:\code{TRUE})}

\item{DEgAlpha}{Significance threshold for DEGs in associations to report.
(Default:\code{NULL}.)}

\item{degPadjColname}{The metadata column name in \code{DegGR} that contains
the adjusted p-values. (Default:\code{pAdj})}
}
\value{
A \link[GenomicRanges]{GRanges} of CRE regions with metadata columns
of \code{predictGene} and \code{predictScore}.
}
\description{
Converts a degCreResList to a hit indexed \link[GenomicRanges]{GRanges} with 
metadata columns of predicted gene target ("predictGene") and the association 
score ("score").
}
\details{
This function simplifies a \code{degResList} to a 
\link[GenomicRanges]{GRanges} with metadata of the predicted associated gene
and a score of that prediction (\code{predictScore}). 
If \code{scoreType = "assocProb"}, the score is the DegCre association
probability. By setting \code{scoreType = "adjOR"} the odds-ratio of the 
association probability is calculated with \link{calcAssocProbOR} and
reported. This can be useful to emphasize associations
that are greatly above background and will tend to weight longer distance
associations more heavily. By setting \code{scoreType = "rawAssocProb"} the 
raw association probability is used. This is the probability of association
without considering the probability that the involved DEG is truly 
differential. This score may be useful when comparing to CRISPRi validation
in the absence of a perturbation.
}
\examples{
#Load required packages.
library(GenomicRanges)

#Load test data.
data(DexNR3C1)

subDegGR <-
 DexNR3C1$DegGR[which(Seqinfo::seqnames(DexNR3C1$DegGR)=="chr1")]
subCreGR <-
 DexNR3C1$CreGR[which(Seqinfo::seqnames(DexNR3C1$CreGR)=="chr1")]

#Generate DegCre results.
degCreResListDexNR3C1 <- runDegCre(DegGR=subDegGR,
                                   DegP=subDegGR$pVal,
                                   DegLfc=subDegGR$logFC,
                                   CreGR=subCreGR,
                                   CreP=subCreGR$pVal,
                                   CreLfc=subCreGR$logFC)

#Convert to GR with assocProb as score.

creToGeneGR <- convDegCreResListToCreGeneScoreGR(degCreResListDexNR3C1,
                                                 scoreType="assocProb",
                                                 geneColname="GeneSymb",
                                                 onlyDEGs=TRUE,
                                                 DEgAlpha=NULL,
                                                 degPadjColname="pAdj")

}
\author{
Brian S. Roberts
}
