% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandomGammaArray-class.R
\docType{class}
\name{RandomGammaArray-class}
\alias{RandomGammaArray-class}
\alias{RandomGammaArraySeed-class}
\alias{RandomGammaMatrix-class}
\alias{sampleDistrParam,RandomGammaArraySeed-method}
\alias{sampleDistrFun,RandomGammaArraySeed-method}
\alias{matrixClass,RandomGammaArray-method}
\alias{RandomGammaArraySeed}
\alias{DelayedArray,RandomGammaArraySeed-method}
\alias{RandomGammaArray}
\title{DelayedArray of random gamma-distributed values}
\usage{
RandomGammaArraySeed(dim, shape, rate = 1, scale = 1/rate, chunkdim = NULL)

\S4method{DelayedArray}{RandomGammaArraySeed}(seed)

RandomGammaArray(dim, shape, rate = 1, scale = 1/rate, chunkdim = NULL)
}
\arguments{
\item{dim}{Integer vector of positive length, specifying the dimensions of the array.}

\item{shape, rate, scale}{Numeric vector used as the argument of the same name in \code{\link{qgamma}}.
Alternatively, a numeric array-like object with the same dimensions as \code{dim}.

If \code{scale} is explicitly supplied, \code{rate} is ignored.}

\item{chunkdim}{Integer vector of length equal to \code{dim}, containing the dimensions of each chunk.}

\item{seed}{A RandomGammaArraySeed object.}
}
\value{
All constructors return an instance of a RandomGammaArray object,
containing random draws from a gamma distribution with the specified parameters.
}
\description{
A \linkS4class{DelayedArray} subclass that performs on-the-fly sampling of gamma-distributed values.
}
\examples{
X <- RandomGammaArraySeed(c(1e5, 1e5), shape=1, rate=10)
Y <- DelayedArray(X)
Y

# Fiddling with the distribution parameters:
X2 <- RandomGammaArraySeed(c(1e5, 1e5), shape=runif(1e5), rate=2)
Y2 <- DelayedArray(X2)
Y2

# Using another array as input:
library(Matrix)
s1 <- rsparsematrix(1e5, 1e5, density=0.00001)
s1 <- abs(DelayedArray(s1)) + 1
X3 <- RandomGammaArraySeed(c(1e5, 1e5), shape=s1, rate=s1+1)
Y3 <- DelayedArray(X3)
Y3

}
\seealso{
The \linkS4class{RandomArraySeed} class, for details on chunking and the distributional parameters.
}
\author{
Aaron Lun
}
