% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pi.R
\name{plot_pi}
\alias{plot_pi}
\title{Plot the estimated proportions of US or USA counts in each group - single-cell RNA-seq data}
\usage{
plot_pi(results, gene_id, cluster_id, type = "USA", CI = TRUE, CI_level = 0.95)
}
\arguments{
\item{results}{a \code{list} of \code{\linkS4class{data.frame}} objects, computed via \code{\link{DifferentialRegulation}}.}

\item{gene_id}{a character, indicating the gene to plot.}

\item{cluster_id}{a character, indicating the cell cluster to plot.}

\item{type}{a character (either 'SU' or 'SUA').
If "SU", it plots the proportion of Spliced and Unspliced counts 
(Ambiguous counts are assigned 50:50 to Spliced and Unspliced counts).
If "SUA" (default), it plots the proportion of Spliced, Unspliced and Ambiguous counts 
(Ambiguous counts are kept separately).
Note that, although US reads are easier to interpret, 
USA reads more closely reflect what is being compared between conditions.}

\item{CI}{a logical ('TRUE' by default), indicating whether to plot a 
profile Wald type confidence interval around the estimated proportions.}

\item{CI_level}{a numeric between 0 and 1, indicating the level of the confidence interval.}
}
\value{
A \code{ggplot} object.
}
\description{
\code{plot_pi} plots the posterior means of the proportions
of US (if 'type' = 'US') or USA (if 'type' = 'USA') counts, in each group.
If 'CI' is TRUE, a profile Wald type confidence interval will also be added;
the level of the confidence interval is specified by 'CI_level'.
}
\examples{
# see the example of DifferentialRegulation function:
help(DifferentialRegulation)

}
\seealso{
\code{\link{DifferentialRegulation}}
}
\author{
Simone Tiberi \email{simone.tiberi@unibo.it}
}
